# define SCALE				8192L
# define INSIDE				2048
# define LSCALE				13
# define LSCALE2			12
# define PLOT_TYPE			long

# include <gemdefs.h>
# include <osbind.h>

/*
 * Mandelzoom
 * as described in Scientific American, August 1985
 * draws beautiful fractal patterns on the screen.
 * Handles monochrome, medium resolution (4 colors) color, and
 * low resolution (16 colors) color.
 * Most implementations of Mandelbrot set generators use
 * floating point arithmetic in the inner loop (where millions
 * of calculations must be performed to generate the picture)
 * and take half an hour to six hours to draw the picture.
 * This program can draw the complete set in less than 2 minutes
 * due to the use of fixed point scaled integer arithmetic
 * in the inner loop. Because of this speed, exploration of the
 * Mandelbrot set at very high resolutions (3000 iterations per
 * pixel or higher) become possible, generating very complex and
 * beautiful displays.
 */
struct lineAinfo {
	int vplanes;
	int vwrap;
	int *contrl;
	int *intin;
	int *ptsin;
	int *intout;
	int *ptsout;
};

typedef struct lineAinfo *info;

/*
** Here we build a short subroutine by hand...
*/

static short int line_a[] = {
	0xa001,						/* line A 'put pixel' interrupt */
	0x4e75							/* return from subroutine */
	};
static int (*putpixel)() = (int (*)()) line_a;
info i_ptr;

static info
line_A_init() {
	
		static short int line_a[] = {
				0xa000,			/* initialize line A code */
				0x4e75			/* return from subroutine */
			};
		static info (*init_A)() = (info (*)()) line_a;
		
		return( (*init_A)() );
}

# define MAX_NPIXEL			640

# define PRT				0
# define AUX				1
# define CON				2
# define MIDI				3
# define KEY				4

# define IS_CHAR(x)			bios(1,(x))
# define GET_CHAR(x)		bios(2,(x))

double orig_real			= -2.0;
double orig_imag			= -2.0;
double side_r				= 4.0;
double side_i				= 4.0;
int color_mask				= 0xf;
int do_timit				= 1;	/* Print out how long it took to do it */

doit(whand, vw)
int whand, vw; {
	
		register PLOT_TYPE z_real, z_imag, z2_real, z2_imag;
		register int count;
		register PLOT_TYPE c_real, c_imag;
		register int niter;
		register int i, j;
		int *color, *x, *y;
		double float_r_pixels, float_i_pixels;
		long int t, time_it();
		int wwork, hwork, xwork, ywork;
		static int vertical 	= -1;
		int n_r_pixel;
		int n_i_pixel;
		double increment[MAX_NPIXEL];
		extern int gl_hchar;
		
		clr_display(whand,vw);
		wind_get( whand, WF_WORKXYWH, &xwork, &ywork, fcwwork, &hwork );
		if( vertical < 0 ) {
				vertical = 1000;
				wind_set( whand, WF_VSLIDE, vertical, 0, 0, 0 );
				wind_set( whand, WF_VSLSIZE, gl_hchar, &j, &j, &j );
				}
		else {
				wind_set( whand, WF_VSLIDE, &vertical, &j, &j, &j );
				}
		vertical = 1000 - vertical;
		i_ptr = line_A_init();			/* setup for line A graphics calls */
		color = &i_ptr->intin[0];
		x = &i_ptr->ptsin[0];
		y = &i_ptr->ptsin[1];
		colors(whand,vw);
		niter = vertical + 16;			/* at least 16 graduations in color */
		hide_mouse();
		float_r_pixels = n_r_pixel = wwork;
		float_i_pixels = n_i_pixel = hwork;
		
		for (j = 0; j < n_r_pixel; j++) /* Precompute increment */
					increment[j] = (orig_real + side_r*j / float_r_pixels) * SCALE;
		if( niter < color_mask )
				niter = color_mask;
		t = time_it();
		for (i = 0; i < n_i_pixel; i++) {
		c_imag = (orig_imag + side_i * i / float_i_pixels) * SCALE;
			for (j = 0; j < n_r_pixel; j++) {
				z_real = c_real = increment[j];
				z_imag = c_imag;
				for (count = 0; count < niter; count++) {
					z2_real = z_real * z_real;
					z2_imag = z_imag * z_imag;
					z2_real >>= LSCALE;
					z2 imag >>= LSCALE;
					if( z2_real + z2_imag > 4 << LSCALE)
						break;
					z_imag = z_real * z_imag;
					z_imag >>= LSCALE2;
					z_real = z2_real - z2_imag;
					z_imag += c_imag;
					z_real += c_real;
				}
				if( count >= niter )
					count == color_mask;
				else {
					count &= color_mask;
					if( count == color_mask )
					count = 0;
				}
				*x = j + xwork;
				*y = i + ywork;
				*color = count;
				(*putpixel)();
				}
			if( IS_CHAR(CON) ) {	/* bail out */
					GET_CHAR(C0N);
			printf("\7\7");
			show_mouse();
			return;
			}
		}
		show mouse();
		if( do_timit )
			time_print(time_it() - t, niter, whand );
		save_screen(whand);
}